#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

// Koristimo __int128_t za sume jer zbir koordinata prelazi long long (9*10^18)
// Ovo je neophodno za tacnost!
typedef __int128_t int128;

int main() {
    // Brzi I/O
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    if (!(cin >> n)) return 0;
    
    vector<long long> X(n), Y(n);
    vector<pair<double, int>> podaci(n);

    for (int i = 0; i < n; i++) {
        cin >> X[i] >> Y[i];
        // Koristimo long double za bolju preciznost ugla
        long double ugao = atan2((long double)Y[i], (long double)X[i]);
        podaci[i] = make_pair((double)ugao, i);
    }

    sort(podaci.begin(), podaci.end());

    vector<long long> X1, Y1;
    vector<double> u; 
    vector<int> ind;
    double PI = acos(-1.0);

    // Dupliranje niza zbog ciklicnosti
    for (int k = 0; k < 2; k++) {
        for (int i = 0; i < n; i++) {
            double tu = podaci[i].first;
            if (k == 1) tu += 2 * PI;
            u.push_back(tu);

            int idx = podaci[i].second;
            X1.push_back(X[idx]);
            Y1.push_back(Y[idx]);
            ind.push_back(idx);
        }
    }

    int r = 0;
    // OVO JE KLJUCNO: curX i curY moraju biti int128!
    int128 curX = 0, curY = 0; 
    int128 maxD = -1;
    int bestL = 0, bestR = -1;

    for (int l = 0; l < n; l++) {
        // Sirimo prozor udesno
        while (r < 2 * n && (u[r] - u[l] <= PI + 1e-9)) {
            curX += X1[r];
            curY += Y1[r];
            
            // Provera maksimuma nakon dodavanja
            int128 sad = curX * curX + curY * curY;
            if (sad > maxD) {
                maxD = sad;
                bestL = l;
                bestR = r;
            }
            r++;
        }
        
        // Smanjujemo prozor sa leve strane (priprema za sledecu iteraciju l)
        curX -= X1[l];
        curY -= Y1[l];

        // OVO JE FALILO: Provera maksimuma nakon skracivanja!
        // Sada je prozor od l+1 do r-1.
        if (l + 1 < r) { 
            int128 sad = curX * curX + curY * curY;
            if (sad > maxD) {
                maxD = sad;
                bestL = l + 1; // Novi pocetak je l+1
                bestR = r - 1; // Trenutni r je vec uvecan, pa je kraj r-1
            }
        } else {
            // Ako je prozor postao prazan (r je ostao iza ili jednak l)
            // Moramo resetovati r da krene od l+1
            r = max(r, l + 1);
            // Resetujemo sume jer je prozor prazan
            if (r == l + 1) { curX = 0; curY = 0; } 
        }
    }

    cout << bestR - bestL + 1 << endl;
    for (int i = bestL; i <= bestR; i++) {
        cout << ind[i] + 1 << " ";
    }
    cout << endl;

    return 0;
}